<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;

/**
 * 插件搭配gocfl.html文件，实现博客外部链接跳转提醒，后台设置倒计时秒数和白名单域名功能。当前版本v1.1.0 by <a href="https://lilog.cn">江有川</a>
 *
 * @package 博客外部链接跳转提醒
 * @author 李的日志
 * @version 1.1.0
 * @link https://lilog.cn
 * @description 为博客的外部链接提供一个可配置的跳转提醒页面，可设置倒计时和白名单域名。
 */
class YQYYcg_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     */
    public static function activate()
    {
        // 将处理函数挂载到页脚输出的钩子上
        Typecho_Plugin::factory('Widget_Archive')->footer = array('YQYYcg_Plugin', 'renderJs');
        return _t('成功激活！别忘了 gocfl.html 文件到网站根目录！');
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     */
    public static function deactivate()
    {
        return _t('插件已禁用');
    }

    /**
     * 获取插件配置面板
     *
     * @param Typecho_Widget_Helper_Form $form 配置面板
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        // 倒计时秒数输入框
        $countdown = new Typecho_Widget_Helper_Form_Element_Text(
            'countdown',
            NULL,
            '5', // 默认值
            _t('倒计时秒数'),
            _t('用户点击外链后，在提醒页面等待跳转的秒数。')
        );
        $form->addInput($countdown->addRule('isInteger', _t('请填写整数')));

        // 白名单域名文本域
        $whitelist = new Typecho_Widget_Helper_Form_Element_Textarea(
            'whitelist',
            NULL,
            '', // 默认值
            _t('白名单域名'),
            _t('在此处输入的域名将不会显示跳转提醒。每行一个域名，例如：lilog.cn')
        );
        $form->addInput($whitelist);
    }

    /**
     * 个人用户的配置面板
     *
     * @param Typecho_Widget_Helper_Form $form
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    /**
     * 插件实现方法
     */
    public static function renderJs()
    {
        // 获取插件的配置信息
        $options = Typecho_Widget::widget('Widget_Options')->plugin('YQYYcg');
        
        // 分割白名单字符串为数组
        $whitelist_str = $options->whitelist ?: '';
        $whitelist_arr = array_filter(array_map('trim', explode("\n", $whitelist_str)));

        // 将 PHP 变量传递给 JavaScript
        $settings = [
            'countdown' => (int)$options->countdown ?: 5,
            'whitelist' => $whitelist_arr,
            'redirectPage' => rtrim(Typecho_Widget::widget('Widget_Options')->siteUrl, '/') . '/gocfl.html'
        ];
        
        // 输出 JS 代码
        echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            const myHost = window.location.hostname;
            const allLinks = document.getElementsByTagName("a");
            const elrSettings = ' . json_encode($settings) . ';

            for (let i = 0; i < allLinks.length; i++) {
                const link = allLinks[i];

                if (link.href && link.getAttribute("href").indexOf("#") !== 0) { // 增加对锚点的判断
                    try {
                        const linkUrl = new URL(link.href, window.location.href);

                        if (linkUrl.hostname && linkUrl.hostname !== myHost && linkUrl.protocol.startsWith("http")) {
                            
                            const isWhitelisted = elrSettings.whitelist.some(domain => linkUrl.hostname === domain || linkUrl.hostname.endsWith("." + domain));

                            if (!isWhitelisted) {
                                link.addEventListener("click", function(event) {
                                    event.preventDefault();
                                    const encodedUrl = encodeURIComponent(this.href);
                                    window.location.href = `${elrSettings.redirectPage}?url=${encodedUrl}&timer=${elrSettings.countdown}`;
                                });
                            }
                        }
                    } catch (e) {
                        // 忽略无效URL, 如 javascript:void(0)
                    }
                }
            }
        });
        </script>';
    }
}